/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import org.betterx.worlds.together.tag.v3.TagRegistry;
import org.jetbrains.annotations.Nullable;

public class TagDataProvider<T>
extends FabricTagProvider<T> {
    @Nullable
    protected final List<String> modIDs;
    protected final TagRegistry<T> tagRegistry;
    private final Set<TagKey<T>> forceWrite;

    public TagDataProvider(TagRegistry<T> tagRegistry, @Nullable List<String> modIDs, FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        this(tagRegistry, modIDs, Set.of(), output, registriesFuture);
    }

    public TagDataProvider(TagRegistry<T> tagRegistry, @Nullable List<String> modIDs, Set<TagKey<T>> forceWriteKeys, FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, tagRegistry.registryKey, registriesFuture);
        this.tagRegistry = tagRegistry;
        this.modIDs = modIDs;
        this.forceWrite = forceWriteKeys;
    }

    protected boolean shouldAdd(ResourceLocation loc) {
        return this.modIDs == null || this.modIDs.contains(loc.m_135827_());
    }

    protected boolean isOptional(TagEntry e) {
        return e.m_215940_(id -> false, id -> false);
    }

    protected void m_6577_(HolderLookup.Provider arg) {
        this.tagRegistry.forEachEntry((tag, locs, tags) -> {
            if (!this.forceWrite.contains(tag) && locs.isEmpty() && tags.isEmpty()) {
                return;
            }
            FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder((TagKey)tag);
            locs.sort(Comparator.comparing(a -> ((ResourceLocation)a.first).toString()));
            tags.sort(Comparator.comparing(a -> ((TagKey)a.first).f_203868_().toString()));
            locs.forEach(pair -> {
                if (this.isOptional((TagEntry)pair.second)) {
                    builder.addOptional((ResourceLocation)pair.first);
                } else {
                    builder.add((ResourceLocation)pair.first);
                }
            });
            tags.forEach(pair -> {
                if (this.isOptional((TagEntry)pair.second)) {
                    builder.addOptionalTag((TagKey)pair.first);
                } else {
                    builder.forceAddTag((TagKey)pair.first);
                }
            });
        }, (tag, loc) -> this.forceWrite.contains(tag) || this.shouldAdd(tag.f_203868_()) || this.shouldAdd((ResourceLocation)loc));
    }
}

